#pragma once

#include <vector>

#include "gamestate.h"

#include "LD10.h"
#include "Level.h"




class CGSGame : public CGameState
{

  public:

    std::vector<std::pair<int,int> >   m_ListSetBombs;

    Level                   m_Level;

    bool                    m_BuildMode;

    int                     m_BombsLeft;

    bool                    m_ButtonReleased;

    int                     m_CurLevel;

    bool                    m_GoPushed;

    GameObject*             m_pSelectedBomb;

    int                     m_SelectedBombIndex;

    bool                    m_ShowName;


    CGSGame();
    virtual ~CGSGame();

    virtual void            Display( IDirect3DDevice8* pDevice );

    virtual void            UpdateFrame( const float fElapsedTime );

    virtual void            OnChar( int iChar );
    virtual void            OnKeyDown( int iChar );
    virtual void            OnMouse( int iX, int iY, int iButtons );

    void                    CalcSelectedBombIndex();
    void                    BackToBuildMode();

};
